/*
 * ssd1306-Test.c
 *
 * Created: 29.05.2024 16:20:08
 * Author : Ralf Ziegler
 */ 

#define F_CPU 8000000UL

#include <avr/io.h>
#include <stdio.h>
#include <stdbool.h> 	
#include <util/delay.h>
#include "lcd.h"

uint16_t ctr;
char test_str[22];

int main(void)
{
	
	lcd_init(OLED_DISPLAYON);			// LCD initialisieren und einschalten
	
	lcd_gotoxy(4,2);					// Stringposition setzten
	lcd_puts("Hello MEXLE!");			// String in LCD-Buffer schreiben
	
	lcd_drawRect(0,0,127,63,WHITE);		// Rechteck in LCD-Buffer zeichnen
	lcd_drawCircle(96,45,7,WHITE);		// Kreis in LCD-Buffer zeichnen
	
	lcd_display();						// LCD-Buffer via I2C an LCD bertragen
	   
    while (1) 
    {
		
		_delay_ms(100);

		/* Uptime */
		sprintf(test_str, "%5.5d", ctr++);
				
		lcd_gotoxy(7,4);				// Stringposition setzten
		lcd_puts(test_str);				// String in LCD-Buffer schreiben
		
		lcd_display();					// Buffer via I2C an LCD bertragen
    }
}

